/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.utils;

import com.electronwill.nightconfig.core.file.FileConfig;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import me.towdium.jecharacters.JustEnoughCharacters;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class Profiler {
    private static final Analyzer[] ANALYZERS = new Analyzer[]{new Analyzer.Construct(Type.SUFFIX, "net/minecraft/client/util/SuffixArray"), new Analyzer.Invoke(Type.CONTAINS, false, "java/lang/String", "contains", "(Ljava/lang/CharSequence;)Z"), new Analyzer.Invoke(Type.CONTAINS, true, "kotlin/text/StringsKt", "contains", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Z)Z"), new Analyzer.Invoke(Type.CONTAINS, true, "kotlin/text/StringsKt", "contains", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence)Z"), new Analyzer.Invoke(Type.EQUALS, false, "java/lang/String", "equals", "(Ljava/lang/Object;)Z"), new Analyzer.Invoke(Type.REGEXP, false, "java/lang/String", "matches", "(Ljava/lang/String;)Z"), new Analyzer.Invoke(Type.REGEXP, false, "java/util/regex/Pattern", "matcher", "(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;")};

    public static Report run() {
        File modDirectory = new File("mods");
        Report r = new Report();
        r.jars = Profiler.scanDirectory(modDirectory);
        return r;
    }

    private static ArrayList<JarContainer> scanDirectory(File f) {
        File[] files = f.listFiles();
        ArrayList<JarContainer> jcs = new ArrayList<JarContainer>();
        Consumer<JarContainer> callback = jcs::add;
        if (files != null) {
            for (File file : files) {
                if (file.isFile() && file.getName().endsWith(".jar")) {
                    try (ZipFile mod = new ZipFile(file);){
                        Profiler.scanJar(mod, callback);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!file.isDirectory()) continue;
                jcs.addAll(Profiler.scanDirectory(file));
            }
        }
        return jcs;
    }

    private static ModContainer[] readInfoOld(InputStream is) {
        Gson gson = new Gson();
        try {
            return (ModContainer[])gson.fromJson((Reader)new InputStreamReader(is), ModContainer[].class);
        }
        catch (Exception e) {
            return new ModContainer[]{(ModContainer)gson.fromJson((Reader)new InputStreamReader(is), ModContainer.class)};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModContainer[] readInfoNew(InputStream is) {
        Path p = null;
        try {
            p = Files.createTempFile("jecharacters", ".toml", new FileAttribute[0]);
            Files.copy(is, p, StandardCopyOption.REPLACE_EXISTING);
            FileConfig c = FileConfig.of((Path)p);
            c.load();
            Collection mods = (Collection)c.get("mods");
            ModContainer[] modContainerArray = (ModContainer[])mods.stream().map(i -> {
                ModContainer mc = new ModContainer();
                mc.modid = (String)i.get("modId");
                mc.name = (String)i.get("displayName");
                mc.version = (String)i.get("version");
                return mc;
            }).toArray(ModContainer[]::new);
            return modContainerArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            ModContainer[] modContainerArray = null;
            return modContainerArray;
        }
        finally {
            if (p != null && !p.toFile().delete()) {
                JustEnoughCharacters.logger.info("Failed to delete temp file.");
            }
        }
    }

    private static void scanJar(ZipFile f, Consumer<JarContainer> cbkJar) {
        EnumMap methods = new EnumMap(Type.class);
        for (Type t : Type.values()) {
            methods.put(t, new TreeSet());
        }
        JarContainer ret = new JarContainer();
        f.stream().forEach(entry -> {
            try (InputStream is = f.getInputStream((ZipEntry)entry);){
                if (entry.getName().equals("META-INF/mods.toml")) {
                    ret.mods = Profiler.readInfoNew(is);
                } else if (entry.getName().equals("mcmod.info")) {
                    ret.mods = Profiler.readInfoOld(is);
                } else if (entry.getName().endsWith(".class")) {
                    long size = entry.getSize() + 4L;
                    if (size > Integer.MAX_VALUE) {
                        JustEnoughCharacters.logger.info("Class file " + entry.getName() + " in jar file " + f.getName() + " is too large, skip.");
                    } else {
                        Profiler.scanClass(is, methods);
                    }
                }
            }
            catch (IOException e) {
                JustEnoughCharacters.logger.info("Fail to read file " + entry.getName() + " in jar file " + f.getName() + ", skip.");
            }
        });
        if (methods.values().stream().anyMatch(i -> !i.isEmpty())) {
            ret.contains = new ArrayList<String>((Collection)methods.get((Object)Type.CONTAINS));
            ret.regExp = new ArrayList<String>((Collection)methods.get((Object)Type.REGEXP));
            ret.suffix = new ArrayList<String>((Collection)methods.get((Object)Type.SUFFIX));
            ret.equals = new ArrayList<String>((Collection)methods.get((Object)Type.EQUALS));
            cbkJar.accept(ret);
        }
    }

    private static void scanClass(InputStream is, EnumMap<Type, Set<String>> methods) throws IOException {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(is);
        try {
            classReader.accept((ClassVisitor)classNode, 0);
        }
        catch (Exception e) {
            if (classNode.name != null) {
                JustEnoughCharacters.logger.info("File decoding of class " + classNode.name + " failed. Try to continue.");
            }
            throw new IOException(e);
        }
        classNode.methods.forEach(methodNode -> {
            for (AbstractInsnNode node : methodNode.instructions) {
                Arrays.stream(ANALYZERS).forEach(i -> i.analyze(node, classNode, (MethodNode)methodNode, methods));
            }
        });
    }

    static enum Type {
        CONTAINS,
        EQUALS,
        REGEXP,
        SUFFIX;

    }

    private static abstract class Analyzer {
        Type type;

        public Analyzer(Type type) {
            this.type = type;
        }

        public void analyze(AbstractInsnNode insn, ClassNode clazz, MethodNode method, EnumMap<Type, Set<String>> methods) {
            if (this.match(insn)) {
                methods.get((Object)this.type).add(clazz.name.replace('/', '.') + ":" + method.name + method.desc);
            }
        }

        abstract boolean match(AbstractInsnNode var1);

        private static class Construct
        extends Analyzer {
            String clazz;

            public Construct(Type type, String clazz) {
                super(type);
                this.clazz = clazz;
            }

            @Override
            boolean match(AbstractInsnNode insn) {
                if (insn instanceof TypeInsnNode) {
                    TypeInsnNode tin = (TypeInsnNode)insn;
                    return tin.getOpcode() == 187 && tin.desc.equals(this.clazz);
                }
                return false;
            }
        }

        private static class Invoke
        extends Analyzer {
            String owner;
            String name;
            String desc;
            int op;
            int tag;

            public Invoke(Type type, boolean isStatic, String owner, String name, String desc) {
                super(type);
                this.op = isStatic ? 184 : 182;
                this.tag = isStatic ? 6 : 5;
                this.owner = owner;
                this.name = name;
                this.desc = desc;
            }

            @Override
            boolean match(AbstractInsnNode insn) {
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode node = (MethodInsnNode)insn;
                    return node.getOpcode() == this.op && node.owner.equals(this.owner) && node.name.equals(this.name) && node.desc.equals(this.desc);
                }
                if (insn instanceof InvokeDynamicInsnNode) {
                    InvokeDynamicInsnNode din = (InvokeDynamicInsnNode)insn;
                    if (din.bsmArgs.length != 3) {
                        return false;
                    }
                    Object arg = din.bsmArgs[1];
                    if (arg instanceof Handle) {
                        Handle handle = (Handle)arg;
                        return handle.getTag() == this.tag && handle.getOwner().equals(this.owner) && handle.getName().equals(this.name) && handle.getDesc().equals(this.desc);
                    }
                }
                return false;
            }
        }
    }

    private static class ModContainer {
        String modid;
        String name;
        String version;

        private ModContainer() {
        }
    }

    private static class JarContainer {
        ModContainer[] mods;
        List<String> contains;
        List<String> regExp;
        List<String> suffix;
        List<String> equals;

        private JarContainer() {
        }
    }

    public static class Report {
        List<JarContainer> jars;
    }
}

